
#######################
# Water Grenade & Egg #
#######################

# Tag entities that explode
tag @e[type=minecraft:snowball] add grenade
tag @e[type=minecraft:egg] add grenade

# Summon an invisible armor stand at newly spawned grenade entities
execute as @e[tag=grenade] at @s if entity @s[tag=!primed] run summon armor_stand ~ ~ ~ {NoGravity:1b,Invulnerable:1b,Invisible:1b,Tags:["grenadeStand","hidename"],DisabledSlots:4144959}
tag @e[tag=grenade] add primed

# If the armor stand no longer detects the grenade nearby, summon an explosion and delete the armor stand
execute as @e[type=armor_stand,tag=grenadeStand] at @s unless entity @e[tag=grenade,distance=..2] run summon creeper ~ ~ ~ {Fuse:0,ExplosionRadius:3b,CustomName:"{\"text\":\"being careless with explosives\",\"color\":\"white\"}"}
execute as @e[type=armor_stand,tag=grenadeStand] at @s unless entity @e[tag=grenade,distance=..2] run kill @s

# Otherwise if it does detect a grenade nearby, teleport the armor stand to the nearest one!
execute as @e[type=armor_stand,tag=grenadeStand] at @s run execute at @e[tag=grenade,distance=..2,sort=nearest] run tp @s ~ ~ ~

# Detect if the egg is in the main or off hand (0 is main hand, 1 is off hand)
scoreboard players set @a[nbt={SelectedItem:{id:"minecraft:egg"}}] EGG_HAND 0
scoreboard players set @a[nbt={Inventory:[{Slot:-106b,id:"minecraft:egg"}]}] EGG_HAND 1

# If the egg is used while in the main hand, replace it
item replace entity @a[scores={EGG_USED=1..,EGG_HAND=0}] weapon.mainhand with minecraft:egg{display:{Name:"{\"text\":\"§bInfinite Eggsplosive\"}",Lore:["{\"text\":\"§fCan Hit Multiple Targets\"}","{\"text\":\"\"}","{\"text\":\"§7An eggsellent choice\"}","{\"text\":\"§7for combat. We're not\"}","{\"text\":\"§7eggsaggerating!\"}"]},Enchantments:[{id:"minecraft:infinity",lvl:1}],HideFlags:7}

# If the egg is used while in the main hand, replace it
item replace entity @a[scores={EGG_USED=1..,EGG_HAND=1}] weapon.offhand with minecraft:egg{display:{Name:"{\"text\":\"§bInfinite Eggsplosive\"}",Lore:["{\"text\":\"§fCan Hit Multiple Targets\"}","{\"text\":\"\"}","{\"text\":\"§7An eggsellent choice\"}","{\"text\":\"§7for combat. We're not\"}","{\"text\":\"§7eggsaggerating!\"}"]},Enchantments:[{id:"minecraft:infinity",lvl:1}],HideFlags:7}

# Set the EGG_USED value back to 0
scoreboard players set @a[scores={EGG_USED=1..}] EGG_USED 0
